#version 330
#extension GL_EXT_gpu_shader4 : enable
//Inside the volcanomod01.fsh  by Flopine
//https://www.shadertoy.com/view/wlc3zH
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Code by Flopine
// Thanks to wsmind, leon, XT95, lsdlive, lamogui, Coyhot, Alkama and YX for teaching me
// Thanks LJ for giving me the love of shadercoding :3

// Thanks to the Cookie Collective, which build a cozy and safe environment for me 
// and other to sprout :)  https://twitter.com/CookieDemoparty

#define time iTime
#define PI 3.141592
#define t (time*0.5)

vec2 hash22 (vec2 x)
{return fract(sin(vec2(dot(x,vec2(12.45,16.1)),dot(x,vec2(26.1,28.14))))*1245.2);}

float hash21 (vec2 x)
{return fract(sin(dot(x,vec2(16.4,17.4)))*1875.2);}

// taken from YX here : https://www.shadertoy.com/view/tdlXW4
// rough shadertoy approximation of the bonzomatic noise texture
vec4 texNoise(vec2 uv)
{
    float f = 0.;
    f += texture2D(iChannel0, uv*.125).r*.5;
    f += texture2D(iChannel0, uv*.25).r*.25;
    f += texture2D(iChannel0, uv*.5).r*.125;
    f += texture2D(iChannel0, uv*1.).r*.125;
    f=pow(f,1.2);
    return vec4(f*.45+.05);
}

float moda (inout vec2 p, float rep)
{
    float per = (2.*PI)/rep;
    float a = atan(p.y,p.x);
    float id = floor(a/per);
    float l = length(p);
    a = mod (a, per)-per*0.5;
    p = vec2(cos(a),sin(a))*l;
    if (abs(id)>=rep/2.) id = abs(id);
    return id;
}

vec3 voro (vec2 uv)
{
    vec2 uv_id = floor (uv);
    vec2 uv_st = fract(uv);

    vec2 m_diff;
    vec2 m_point;
    vec2 m_neighbor;
    float m_dist = 10.;

    for (int j = -1; j<=1; j++)
    {
        for (int i = -1; i<=1; i++)
        {
            vec2 neighbor = vec2(float(i), float(j));
            vec2 point = hash22(uv_id + neighbor);
            point = 0.5+0.5*sin(2.*PI*point+t);
            vec2 diff = neighbor + point - uv_st;

            float dist = length(diff);
            if (dist < m_dist)
            {
                m_dist = dist;
                m_point = point;
                m_diff = diff;
                m_neighbor = neighbor;
            }
        }
    }

    m_dist = 10.;
    for (int j = -2; j<=2; j++)
    {
        for (int i = -2; i<=2; i++)
        {
            if (i==0 && j==0) continue;
            vec2 neighbor = m_neighbor + vec2(float(i), float(j));
            vec2 point = hash22(uv_id + neighbor);
            point = 0.5+0.5*sin(point*2.*PI+t);
            vec2 diff = neighbor + point - uv_st;
            float dist = dot(0.5*(m_diff+diff), normalize(diff-m_diff));
            m_point = point;
            m_dist = min(m_dist, dist);
        }
    }

    return vec3(m_point, m_dist);
}


float cyl (vec3 p, float r, float h)
{ return max(length(p.xy)-r, abs(p.z)-h);}

float box (vec3 p, vec3 c)
{return length(max(abs(p)-c,0.));}

vec3 v;
float g1 = 0.;
float lava (vec3 p)
{
    p.y += 1.5;
    v = voro(p.xz*1.5);
    p.y += texNoise(v.xy*0.6).r*0.2;
    p.y -= smoothstep(0.08,0.15,v.z)*0.03;
    float d = abs(p.y)-0.2; 
    g1 += 0.1/(0.1+d*d);
    return d;
}

float room (vec3 p)
{
    vec2 uu = vec2(atan(p.z,p.x), p.y);
    float offset = texNoise(uu*vec2(PI,.2)).r*1.5;
    return -cyl(p.xzy, 8.+offset, 8.);
}

vec3 p_platform;
float platform (vec3 p)
{
    p.y += 1.2;
    float p_id = moda(p.xz, 6.);
    p.y += sin(p_id+t)*0.5+0.5;
    p.x -= 4.;
    p_platform = p;
    return box(p,vec3(.8,.3,.8))-0.05;
}

vec3 p_dragon;
float dragon (vec3 p)
{
    p.z -= 5.;
    p.y -= 1.;
    p.y += sin(p.z*1.2+t);
    p.x += sin(p.z);
    p_dragon = p;
    return cyl(p,0.1-p.z*0.05,15.);
}

int mat_id;
float SDF (vec3 p)
{
    float drag = dragon(p);
    float plat = platform(p);
    float l = lava(p);
    float r = room(p);

    float d = min(min(drag,plat),min(max(l,cyl(p.xzy,9.,15.)),r));

    if (d == l || d  == r) mat_id = 1;
    if (d == plat) mat_id = 2;
    if (d == drag) mat_id = 3;

    return d;
}

vec3 getcam (vec3 ro, vec3 tar, vec2 uv)
{
    vec3 f = normalize(tar-ro);
    vec3 l = normalize(cross(vec3(0.,1.,0.),f));
    vec3 u = normalize(cross(f,l));
    return normalize(f*1. + l*uv.x + u*uv.y);
}

float platform_texture (vec2 uv)
{
    uv = abs(uv);
    float c = max(uv.x,uv.y);  
    return clamp(step(0.4, c)+step(c, 0.3)*step(0.1,c),0.,1.);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = vec2(gl_FragCoord.x / iResolution.x, gl_FragCoord.y / iResolution.y);
    uv -= 0.5;
    uv /= vec2(iResolution.y / iResolution.x, 1);

    float dither = hash21(uv);

    uv += texNoise(uv*0.1 - vec2(0.,time*0.05)).rg*0.1;

    vec3 ro= vec3(5.,3.5,-6.),
        p = ro,
        rd = getcam(ro,vec3(0.),uv),
        l = vec3(0.,1.,-1.),
        col = vec3(0.);

    float shad = 0.;

    for (float i=0.; i<100.;i++)
    {
        float d = SDF(p);
        if (d<0.01)
        {
            shad = i/100.;
            break;
        }
        d *= 0.6+dither*0.1;
        p += d*rd; 
    }

    if (mat_id == 1)
    {
        col = vec3(shad);
    }

    if (mat_id == 2)
    {
        vec3 albedo = (platform_texture(p_platform.xz*0.5) == 0.) ? vec3(0.6,0.5,0.2) : vec3(p_platform.y, p_platform.y*0.6, p_platform.y*0.2);
        col = albedo;
    }
    
    if (mat_id == 3)
    {
        vec2 dragon_uv = vec2(atan(p_dragon.y,p_dragon.x),p_dragon.z); 
        vec3 albedo = vec3(-p_dragon.z,-p_dragon.z*0.4,-p_dragon.z*0.2)*0.8*voro(dragon_uv*vec2(1.,PI)).z*1.5;
        col = albedo;
    }
    col *= 1.-shad; 
    col += g1*vec3(0.8,0.4,0.2)*0.18*(1.-v.z*2.);

    gl_FragColor = vec4(col,1.);
}